require "ev/sgml"

class SGMLObject
  def to_x(closetags=true)
    res	= ""

    parsetree("prechildren_to_x", "postchildren_to_x", res, closetags)

    res
  end
end

class Text < SGMLObject
  def prechildren_to_x(res, closetags)
    res << @text.strip	unless @text.strip.empty?
  end
end

class Comment < SGMLObject
  def prechildren_to_x(res, closetags)
    res << "\n"	if not previous([], [Text]).kind_of?(Comment)
    lines	= @text.gsub(/(<!--|-->)/, "").lf.split(/\n/)
    if lines.length == 1
      res << "  "*(@level-1) + "<!-- " + lines[0].strip + " -->" + "\n"
    else
      res << "  "*(@level-1) + "<!--" + "\n"
      res << lines.collect{|s| "  "*(@level-1) + s.strip}.delete_if{|s| s.compress.empty?}.join("\n")
      res << "\n"
      res << "  "*(@level-1) + "-->" + "\n"
      res << "\n"
    end
  end
end

class Special < SGMLObject
  def prechildren_to_x(res, closetags)
    res << "  "*(@level-1) + @text.compress + "\n"
  end
end

class Instruction < SGMLObject
  def prechildren_to_x(res, closetags)
    res << "  "*(@level-1) + @text.compress + "\n"
  end
end

class OpenTag < Tag
  def prechildren_to_x(res, closetags)
    a	= [@subtype]

    args	= @args.dup
    args.delete("id")
    args.delete("name")
    args	= args.sort
    args.unshift(["id", @args["id"]])		if @args.include?("id")
    args.unshift(["name", @args["name"]])	if @args.include?("name")

    args.each do |k, v|
      if not v.include?("'")
        a << "#{k}='#{v}'"
      else
        if not v.include?('"')
          a << "#{k}=\"#{v}\""
        else
          a << "#{k}='#{v.gsub(/\'/, '"')}'"
        end
      end
    end

    if @children.length == 0 or (@children.length == 1 and @children[0].kind_of?(Text) and @children[0].text.compress.empty?)
      res << "  "*(@level-1) + "<#{a.join(" ")}/>" + "\n"
    else
      if @children.length == 1 and @children[0].kind_of?(Text) and @children[0].text.lf.split(/\n/).length == 1
        res << "  "*(@level-1) + "<#{a.join(" ")}>"
      else
        res << "  "*(@level-1) + "<#{a.join(" ")}>" + "\n"
      end
    end
  end

  def postchildren_to_x(res, closetags)
    if closetags
      unless @children.length == 0 or (@children.length == 1 and @children[0].kind_of?(Text) and @children[0].text.compress.empty?)
        res << "\n"		if @children.length == 1 and @children[0].kind_of?(Text) and @children[0].text.lf.split(/\n/).length > 1
        res << "  "*(@level-1)	unless @children.length == 1 and @children[0].kind_of?(Text) and @children[0].text.lf.split(/\n/).length == 1
        res << "</#{@subtype}>"
        res << "\n"
      end
    end
  end
end

class XML < SGML
  def to_x(closetags=true)
    res	= ""

    parsetree("prechildren_to_x", "postchildren_to_x", res, closetags)

    res
  end
end
