require "ev/oldandnewlocation"
require "ev/db"
require "ev/rwd"

RWDFile	= "rwdkana.rwd"
Testset	= "karakters.tsv"

dash, alpha, numeric	= ARGV.to_par

file	= (oldlocation(alpha.shift) or Testset)
port	= numeric.shift
remote	= dash.include?("-r")

if dash.include?("--testset")
  puts File.new(Testset).readlines
  exit
end

class Kana < RWDialog
  def initialize(rwdfile, file)
    @file	= file
    @hiragana	= "on"
    @katakana	= "on"

    @db		= TSVFile.new(@file)

    super(rwdfile)

    @rwd_ignore_vars << "@db"
  end

  def self.file(rwdfile, file)
    new(File.new(rwdfile).readlines, file)
  end

  def main
    @foutofgoed	= ""
    @goed	= 0
    @totaal	= 0
    @percentage	= 0
  end

  def ask
    if @hiragana != "on" and @katakana != "on"
      error "Select at least 1 character set."
    else
      @rwd_window	= "ask"

      res	= []

      db	= @db
      db	= @db.subset("KarakterSet", "hiragana")	if @katakana == "off"
      db	= @db.subset("KarakterSet", "katakana")	if @hiragana == "off"

      keys	= db.keys
      set	= db.subset(nil, nil, "KarakterSet")
      values	= db.subset(nil, nil, "Betekenis")

      1.upto 4 do
        i	= nil
        i	= rand(keys.size)	while i.nil? or res.include?(i)
        res << i
      end

      res2	= {}
      res.each do |n|
        karakter	= keys[n]
        res2[karakter]	= ["#{values[karakter]}", "(#{set[karakter]})"]
      end

      @table	= res2.rwd_table("antwoord")

      @gevraagd		= keys[res[rand(res.size)]][0]
      @juisteantwoord	= "#{values[[@gevraagd]]} (#{set[[@gevraagd]]})"
      @antwoord		= ""
    end
  end

  def answer
    if @antwoord.empty?
      error("You have to select a row.")
    else
      @foutofgoed	= (@gevraagd == @antwoord ? "Correct" : "Wrong. Answer: #{@juisteantwoord}" )
      @goed	+= 1	if @gevraagd == @antwoord
      @totaal	+= 1
      @percentage	= 100*@goed/@totaal

      ask
    end
  end
end

Kana.file(RWDFile, file).serve(port, remote ? ".rwduids" : nil)
