class String
  def fuzzy_match( str_in )
    return 0.0 if str_in == nil
    return 1.0 if self == str_in
    # Make a graph of each word (okay, so its not a true graph, but is similar)
    graph_A = Array.new
    graph_B = Array.new

    # "graph" self
    last = self.length
    (0..last).each{ |ff|
      loc  = self.length
      break if ff == last - 1
      wordB = (1..(last-1)).to_a.reverse!
#p [self, str_in, ff, last, wordB]
      unless wordB.nil? or wordB.empty?
        wordB.each{ |ss|
          break if ss == ff
          graph_A.push( "#{self[ff..ss]}" )
        }
      end
    }

    # "graph" input string
    last = str_in.length
    (0..last).each{ |ff|
      loc  = str_in.length
      break if ff == last - 1
      wordB = (1..(last-1)).to_a.reverse!
      unless wordB.nil? or wordB.empty?
        wordB.each{ |ss|
          break if ss == ff
          graph_B.push( "#{str_in[ff..ss]}" )
        }
      end
    }

    # count how many of these "graph edges" we have that are the same
    matches = Array.new
    graph_A.each{ |aa|
      matches.push( aa ) if( graph_B.include?( aa ) )
    }

    matches.sort!{ |x,y| x.length <=> y.length }  # For eliminating subsets, we want to start with the smallest hits

    # eliminate any subsets
    mclone = matches.dup
    mclone.each_index { |ii|
      reg = Regexp.compile( mclone[ii] )
      count = 0.0
      matches.each{ |xx|
        count += 1 if xx =~ reg
      }
      matches.delete(mclone[ii]) if count > 1
    }

    score = 0.0
    matches.each{ |mm| score += mm.length }

    self.length > str_in.length ? largest = self.length : largest = str_in.length
    return score/largest
  end

  def fm(s)
    if self.empty? or s.empty?
      0.0
    else
      self.fuzzy_match(s)/self.length*s.length
    end
  end
end
