require "ev/ruby"
require "ev/net"

begin
  require "win32ole"
  require "win32/registry"
rescue LoadError
  $".push "win32ole.so"
  $".push "win32/registry.rb"
end

def windowsbrowser
  $stderr.puts "Looking for default browser..."

  filetype	= "htmlfile"
  application	= nil

  begin
    Win32::Registry::HKEY_CLASSES_ROOT.open(".html") do |reg|
      filetype		= reg[""]
    end

    Win32::Registry::HKEY_CLASSES_ROOT.open(filetype + "\\shell\\open\\command") do |reg|
      application	= reg[""]
    end
  rescue NameError
    $stderr.puts "Only available for Windows and Cygwin."
  end

  application
end

def cygwinbrowser
  browser, *args	= windowsbrowser.splitwords
  browser		= browser.gsub(/\\/, "/")
  #browser		= browser

  args.collect!{|a| a.gsub(/\\/, "/")}
  #args.collect!{|a| "\"%s\"" % [a.gsub(/\\/, "/")]}
  #args.collect!{|a| "\"%s\"" % [a]}

  res	= "\"%s\" %s" % [browser, args.join(" ")]
  res
end

def linuxbrowser
  application	= ""

  application	= `which galeon		2> /dev/null`.chomp	if application.empty?
  application	= `which mozilla	2> /dev/null`.chomp	if application.empty?
  application	= `which firefox	2> /dev/null`.chomp	if application.empty?
  application	= `which opera		2> /dev/null`.chomp	if application.empty?
  application	= `which konqueror	2> /dev/null`.chomp	if application.empty?
  application	= `which htmlview	2> /dev/null`.chomp	if application.empty?
  application	= nil						if application.empty?

  application
end

def defaultbrowser
  res	= nil
  res	= windowsbrowser	if windows?
  res	= cygwinbrowser		if cygwin?
  res	= linuxbrowser		if linux?
  res
end

def showurlinbrowser(url, browser=defaultbrowser)
  command	= "#{browser} \"#{url}\""

  system(command)	or $stderr.puts "Starting of the browser failed, or the browser terminated abnormally.\nCommand => #{command}"
end

def showinbrowser(html, browser=defaultbrowser)
  port, io	= TCPServer.freeport(7701, 7709)

  unless browser.nil?
    Thread.new do
      begin
	Thread.pass

        showurlinbrowser("http://localhost:#{port}/", browser)
      rescue
      end
    end
  end

  HTTPServer.serve([port, io]) do |req, resp|
    resp << html

    resp.stop
  end
end

def tab2html(tab)
  res	= ""

  tab	= tab.to_html(false)

  res << "<html>\n"
  res << "<body>\n"
  res << "<table align='center' border='1' cellspacing='0' cellpadding='3'>\n"
  res << "<tbody>\n"

  tab.split(/\r*\n/).each do |line|
    res << "<tr>\n"

    line.split(/\t/, -1).each do |veld|
      veld	= "&nbsp;"	if veld.compress.empty?

      res << "<td>%s</td>\n" % veld
    end

    res << "</tr>\n"
  end

  res << "</tbody>\n"
  res << "</table>\n"
  res << "</body>\n"
  res << "</html>\n"

  res
end
